/* global chrome */

window.addEventListener('message', event => {
  if (event.data?.type === 'WIDGET_BUILDER_READY') {
    const manifest = chrome.runtime.getManifest()

    event.source.postMessage({
      type: 'EXTENSION_CONTEXT',
      data: {
        version: manifest.version
      }
    }, event.origin)
  }

  if (event.data?.type === 'COPY_TO_CLIPBOARD') {
    navigator.clipboard.writeText(event.data.code)
  }
})
